/*
 * Decompiled with CFR 0.152.
 */
package fr.asip.cps3.exemple.modele.traitements.fonctionsPKCS11.slotscartes;

import fr.asip.cps3.exemple.modele.exceptions.ExceptionProgrammeExemple;
import fr.asip.cps3.exemple.modele.exceptions.ExceptionTraitement;
import fr.asip.cps3.exemple.modele.resultats.Resultat;
import fr.asip.cps3.exemple.modele.traitements.util.TraitementsUtil;
import iaik.pkcs.pkcs11.wrapper.PKCS11;
import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;
import org.apache.log4j.Logger;

public class ModifPIN {
    private static Logger log = Logger.getLogger(ModifPIN.class);

    public static Resultat traitementP11(PKCS11 pKCS11, long l, char[] cArray, char[] cArray2) throws ExceptionTraitement {
        try {
            if (pKCS11 != null) {
                Resultat resultat = new Resultat("Modification du code porteur de la carte (C_SetPIN)");
                try {
                    if (cArray == null || cArray2 == null) {
                        log.error((Object)"L'ancien et/ou le nouveau code porteur est nul");
                        throw new ExceptionTraitement(12, "L'ancien et/ou le nouveau code porteur est nul");
                    }
                    pKCS11.C_SetPIN(l, cArray, cArray2);
                }
                catch (PKCS11Exception pKCS11Exception) {
                    log.info((Object)("Operation echouee : " + TraitementsUtil.retranscritCodeRetour(pKCS11Exception.getErrorCode())));
                    resultat.setCodeRetour(pKCS11Exception.getErrorCode());
                }
                return resultat;
            }
            log.error((Object)"La librairie est nulle");
            throw new ExceptionTraitement(12, "La librairie est nulle");
        }
        catch (Throwable throwable) {
            if (throwable instanceof ExceptionTraitement) {
                throw (ExceptionTraitement)throwable;
            }
            log.error((Object)("Une erreur inattendue est survenue : " + ExceptionProgrammeExemple.getStacktrace(throwable)));
            throw new ExceptionTraitement(12, "Une erreur inattendue est survenue");
        }
    }
}

